function CDX = set_zero_RP_MPR_syst(CDX, business_cycle_length)
% --------------------------------------------------------------------------------------------------
% Set the market price of systematic risk equal to zero
% --------------------------------------------------------------------------------------------------
% CDX                       ... credit index structure (see 'all_steps_in_a_row.m')
% business_cycle_length     ... typical business cycle length in years
% --------------------------------------------------------------------------------------------------
% sample call: set_zero_RP_MPR_syst(cdx_tv_monthly10, 6)
% --------------------------------------------------------------------------------------------------

CDX.AJD_common_factor.theta = CDX.AJD_common_factor.theta .* CDX.AJD_common_factor.k / (log(2)*2/business_cycle_length);
CDX.AJD_common_factor.k = repmat((log(2)*2/business_cycle_length), size(CDX.AJD_common_factor.k));